/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.roles;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.NpcMiscInventory;
import noppes.npcs.api.constants.JobType;
import noppes.npcs.api.entity.data.role.IJobItemGiver;
import noppes.npcs.controllers.GlobalDataController;
import noppes.npcs.controllers.data.Availability;
import noppes.npcs.controllers.data.Line;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerItemGiverData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.JobInterface;

public class JobItemGiver
extends JobInterface
implements IJobItemGiver {
    public Availability availability;
    public int cooldown = 10;
    public int cooldownType = 0;
    public int givingMethod = 0;
    public NpcMiscInventory inventory;
    public int itemGiverId = 0;
    public List<String> lines = new ArrayList<String>();
    private final List<EntityPlayer> recentlyChecked = new ArrayList<EntityPlayer>();
    private int ticks = 10;
    private List<EntityPlayer> toCheck;

    public JobItemGiver(EntityNPCInterface npc) {
        super(npc);
        this.availability = new Availability();
        this.inventory = new NpcMiscInventory(9);
        this.lines.add("Have these items {player}");
        this.type = JobType.ITEM_GIVER;
    }

    @Override
    public boolean aiContinueExecute() {
        return false;
    }

    @Override
    public boolean aiShouldExecute() {
        if (this.npc.isAttacking()) {
            return false;
        }
        --this.ticks;
        if (this.ticks > 0) {
            return false;
        }
        this.ticks = 10;
        List<Object> list = new ArrayList<EntityPlayer>();
        try {
            list = this.npc.field_70170_p.func_72872_a(EntityPlayer.class, this.npc.func_174813_aQ().func_72314_b(3.0, 3.0, 3.0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.toCheck = list;
        this.toCheck.removeAll(this.recentlyChecked);
        List listMax = new ArrayList();
        try {
            listMax = this.npc.field_70170_p.func_72872_a(EntityPlayer.class, this.npc.func_174813_aQ().func_72314_b(10.0, 10.0, 10.0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.recentlyChecked.retainAll(listMax);
        this.recentlyChecked.addAll(this.toCheck);
        return !this.toCheck.isEmpty();
    }

    @Override
    public void aiStartExecuting() {
        for (EntityPlayer player : this.toCheck) {
            if (!this.npc.canSee((Entity)player) || !this.availability.isAvailable(player)) continue;
            this.recentlyChecked.add(player);
            this.interact(player);
        }
    }

    private boolean canPlayerInteract(PlayerItemGiverData data) {
        if (this.inventory.items.isEmpty()) {
            return false;
        }
        if (this.isOnTimer()) {
            return data.notInteractedBefore(this) || data.getTime(this) + (long)this.cooldown * 1000L < System.currentTimeMillis();
        }
        if (this.isGiveOnce()) {
            return data.notInteractedBefore(this);
        }
        return this.isDaily() && (data.notInteractedBefore(this) || (long)this.getDay() > data.getTime(this));
    }

    private int freeInventorySlots(EntityPlayer player) {
        int i = 0;
        for (ItemStack is : player.field_71071_by.field_70462_a) {
            if (!NoppesUtilServer.IsItemStackNull(is)) continue;
            ++i;
        }
        return i;
    }

    private int getDay() {
        return (int)(this.npc.field_70170_p.func_82737_E() / 24000L);
    }

    private boolean giveItems(EntityPlayer player) {
        PlayerItemGiverData data = PlayerData.get((EntityPlayer)player).itemgiverData;
        if (!this.canPlayerInteract(data)) {
            return false;
        }
        Vector<ItemStack> items = new Vector<ItemStack>();
        Vector<Object> toGive = new Vector<ItemStack>();
        for (Object is : this.inventory.items) {
            if (is.func_190926_b()) continue;
            items.add(is.func_77946_l());
        }
        if (items.isEmpty()) {
            return false;
        }
        if (this.isAllGiver()) {
            toGive = items;
        } else if (this.isRemainingGiver()) {
            for (Object is : items) {
                if (this.playerHasItem(player, is.func_77973_b())) continue;
                toGive.add((ItemStack)is);
            }
        } else if (this.isRandomGiver()) {
            toGive.add(((ItemStack)items.get(this.npc.field_70170_p.field_73012_v.nextInt(items.size()))).func_77946_l());
        } else if (this.isGiverWhenNotOwnedAny()) {
            boolean ownsItems = false;
            for (ItemStack is2 : items) {
                if (!this.playerHasItem(player, is2.func_77973_b())) continue;
                ownsItems = true;
                break;
            }
            if (ownsItems) {
                return false;
            }
            toGive = items;
        } else if (this.isChainedGiver()) {
            int itemIndex = data.getItemIndex(this);
            int i = 0;
            for (ItemStack item : this.inventory.items) {
                if (i == itemIndex) {
                    toGive.add(item);
                    break;
                }
                ++i;
            }
        }
        if (toGive.isEmpty()) {
            return false;
        }
        if (this.givePlayerItems(player, toGive)) {
            if (!this.lines.isEmpty()) {
                this.npc.say(player, new Line(this.lines.get(this.npc.func_70681_au().nextInt(this.lines.size()))));
            }
            if (this.isDaily()) {
                data.setTime(this, this.getDay());
            } else {
                data.setTime(this, System.currentTimeMillis());
            }
            if (this.isChainedGiver()) {
                data.setItemIndex(this, (data.getItemIndex(this) + 1) % this.inventory.items.size());
            }
            return true;
        }
        return false;
    }

    private boolean givePlayerItems(EntityPlayer player, Vector<ItemStack> toGive) {
        if (toGive.isEmpty()) {
            return false;
        }
        if (this.freeInventorySlots(player) < toGive.size()) {
            return false;
        }
        for (ItemStack is : toGive) {
            this.npc.givePlayerItem(player, is);
        }
        return true;
    }

    private void interact(EntityPlayer player) {
        if (!this.giveItems(player)) {
            this.npc.say(player, this.npc.advanced.getInteractLine());
        }
    }

    private boolean isAllGiver() {
        return this.givingMethod == 1;
    }

    private boolean isChainedGiver() {
        return this.givingMethod == 4;
    }

    private boolean isDaily() {
        return this.cooldownType == 2;
    }

    private boolean isGiveOnce() {
        return this.cooldownType == 1;
    }

    private boolean isGiverWhenNotOwnedAny() {
        return this.givingMethod == 3;
    }

    public boolean isOnTimer() {
        return this.cooldownType == 0;
    }

    private boolean isRandomGiver() {
        return this.givingMethod == 0;
    }

    private boolean isRemainingGiver() {
        return this.givingMethod == 2;
    }

    private boolean playerHasItem(EntityPlayer player, Item item) {
        for (ItemStack is : player.field_71071_by.field_70462_a) {
            if (is.func_190926_b() || is.func_77973_b() != item) continue;
            return true;
        }
        for (ItemStack is : player.field_71071_by.field_70460_b) {
            if (is.func_190926_b() || is.func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    @Override
    public void load(NBTTagCompound compound) {
        super.load(compound);
        this.type = JobType.ITEM_GIVER;
        this.itemGiverId = compound.func_74762_e("ItemGiverId");
        this.cooldownType = compound.func_74762_e("igCooldownType");
        this.givingMethod = compound.func_74762_e("igGivingMethod");
        this.cooldown = compound.func_74762_e("igCooldown");
        this.lines = NBTTags.getStringList(compound.func_150295_c("igLines", 10));
        this.inventory.load(compound.func_74775_l("igJobInventory"));
        if (this.itemGiverId == 0 && GlobalDataController.instance != null) {
            this.itemGiverId = GlobalDataController.instance.incrementItemGiverId();
        }
        this.availability.load(compound.func_74775_l("igAvailability"));
    }

    @Override
    public NBTTagCompound save(NBTTagCompound compound) {
        super.save(compound);
        compound.func_74768_a("igCooldownType", this.cooldownType);
        compound.func_74768_a("igGivingMethod", this.givingMethod);
        compound.func_74768_a("igCooldown", this.cooldown);
        compound.func_74768_a("ItemGiverId", this.itemGiverId);
        compound.func_74782_a("igLines", (NBTBase)NBTTags.nbtStringList(this.lines));
        compound.func_74782_a("igJobInventory", (NBTBase)this.inventory.save());
        compound.func_74782_a("igAvailability", (NBTBase)this.availability.save(new NBTTagCompound()));
        return compound;
    }
}

